<?php
/**
 *
 * @package [Parent Theme]
 * @author  gaviasthemes <gaviasthemes@gmail.com>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU Public License
 * 
 */

function codesk_child_scripts() {
   wp_enqueue_style( 'codesk-parent-style', get_template_directory_uri(). '/style.css');
   wp_enqueue_style( 'codesk-child-style', get_stylesheet_uri());
}
add_action( 'wp_enqueue_scripts', 'codesk_child_scripts', 9999 );


// CATEGORY TEXT EDITOR --- START
if( is_admin() ) {
// LETS REMOVE THE HTML FILTERING
remove_filter( 'pre_term_description', 'wp_filter_kses' );
remove_filter( 'term_description', 'wp_kses_data' );

// LETS ADD OUR NEW CAT DESCRIPTION BOX
add_filter('edit_category_form_fields', 'filter_wordpress_category_editor');
function filter_wordpress_category_editor($tag) {
    ?>
    <table class="form-table">
        <tr class="form-field">
            <th scope="row" valign="top"><label for="description"><?php _ex('Description', 'Taxonomy Description'); ?></label></th>
            <td>
            <?php
                $settings = array('wpautop' => true, 'media_buttons' => true, 'quicktags' => true, 'textarea_rows' => '15', 'textarea_name' => 'description' );  
          wp_editor(html_entity_decode($tag->description , ENT_QUOTES, 'UTF-8'), 'description1', $settings);
            ?>
            <br />
            <span class="description"><?php _e('The description is not prominent by default; however, some themes may show it.'); ?></span>
            </td>
        </tr>
    </table>
    <?php
}

// HIDE THE DEFAULT CAT DESCRIPTION BOX USING JQUERY
add_action('admin_head', 'remove_default_category_description');
function remove_default_category_description()
{
    global $current_screen;
    if ( $current_screen->id == 'edit-category' )
    {
    ?>
        <script type="text/javascript">
        jQuery(function($) {
            $('textarea#description').closest('tr.form-field').remove();
        });
        </script>
    <?php
    }
}
}
// CATEGORY TEXT EDITOR --- END

function exclude_category_widget($args) {
    $exclude_category_id = 30; // Replace 1 with the actual ID of the category you want to exclude
    $args['exclude'] = $exclude_category_id;
    return $args;
}

add_filter('widget_categories_args', 'exclude_category_widget');


function pine_dynamic_select_field_values ( $scanned_tag, $replace ) {  
  
    if ( $scanned_tag['name'] != 'category' )  
        return $scanned_tag;

    $rows = get_categories(); 
  
    if ( ! $rows )  
        return $scanned_tag;

    foreach ( $rows as $row ) { 
         if($row->name != "Blog" && $row->name != "Uncategorized"){	
			$scanned_tag['raw_values'][] = $row->name . '|' . $row->name;
		 }
    }

    $pipes = new WPCF7_Pipes($scanned_tag['raw_values']);

    $scanned_tag['values'] = $pipes->collect_befores();
    $scanned_tag['labels'] = $pipes->collect_afters();
    $scanned_tag['pipes'] = $pipes;
  
    return $scanned_tag;  
}  

add_filter( 'wpcf7_form_tag', 'pine_dynamic_select_field_values', 10, 2); 
