<?php
/*

* Template Name: blog

* Template Post Type: (enter the post type: post, page, product, etc)

*/


 get_header(); ?>

<section class="entry-hero page-hero-section entry-hero-layout-standard">
	<div class="entry-hero-container-inner">
		<div class="hero-section-overlay"></div>
		<div class="hero-container site-container">
			<header class="entry-header page-title title-align-center title-tablet-align-inherit title-mobile-align-inherit">
				<h1 class="page-title"><?php the_title(); ?> </h1>
			</header>
		</div>
	</div>
</section><!-- .entry-hero -->


<div id="primary" class="content-area">
	<div class="content-container site-container">
				<main id="main" class="post-main-content" role="main">
					<div id="archive-container" class="content-wrap grid-cols post-archive grid-sm-col-2 grid-lg-col-2 item-image-style-above">
					<?php
						$paged = (get_query_var( 'paged' )) ? get_query_var( 'paged' ) : 1;
						$args = array(
							'post_type' => 'post',
						   // 'post_status' => 'publish',
							'category_name' => 'Blog',
							'posts_per_page' => 5,
							'paged' => $paged,
						);
						$arr_posts = new WP_Query( $args );
					 
						if ( $arr_posts->have_posts() ) :
		 
						while ( $arr_posts->have_posts() ) :
					$arr_posts->the_post();
					?>
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <div style="blog_post_image"><a href="<?php the_permalink(); ?>" ><?php
                if ( has_post_thumbnail() ) :
                    the_post_thumbnail();
                endif;
                ?></a></div>
				<div class="entry-content-wrap">
                <header class="entry-header">
					<h2 class="heading_main main-post-heading">
						<a href="<?php the_permalink(); ?>" ><?php the_title(); ?></a></h2>
					<h6>    
						<?php echo get_the_author();?>
						,<span>
							<?php
						echo date('F j, Y',strtotime(get_the_date('y-m-d')));
						?>
						</span>
                    </h6>
                </header>
                <div class="entry-content">
                    <?php 
				 
					// echo the_permalink(); 
					the_excerpt(); 
					?>
					
					<span class="custom_read_btn"><p ><a href="<?php echo the_permalink(); ?>">Read More<i class="fa fa-long-arrow-right " aria-hidden="true"></i></a></p></span>
                </div>
				</div>
            </article>
            <?php
        endwhile;
       
    endif;
    ?></div>
				</main>
			
			<?php get_sidebar();?>
		</div>
	</div>



			
 <?php get_footer();
 
 
 